/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DuelModifier
extends Modifier
implements MeleeHitModifierHook,
MeleeDamageModifierHook,
ProjectileHitModifierHook,
ConditionalStatModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_DAMAGE, ModifierHooks.MELEE_HIT);
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player != null && this.getAnger(player) > 5) {
            return (float)((double)damage + (double)(5 * (this.getAnger(player) - 5)) * Math.cbrt(modifier.getLevel()));
        }
        return damage;
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        Player player = context.getPlayerAttacker();
        if (player != null && this.getAnger(player) <= 5) {
            return knockback * (1.0f + (float)(6 - this.getAnger(player)) * 0.2f);
        }
        return knockback;
    }

    public int getAnger(Player player) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        List targets = player.f_19853_.m_45976_(Mob.class, new AABB(x - 10.0, y - 10.0, z - 10.0, x + 10.0, y + 10.0, z + 10.0));
        int sum = 0;
        for (Mob target : targets) {
            Brain brain;
            if (!(target instanceof Monster) || (brain = target.m_6274_()).m_21952_(MemoryModuleType.f_26334_).orElse(null) != player.m_20148_()) continue;
            ++sum;
        }
        return sum;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Player player;
        if (stat == ToolStats.PROJECTILE_DAMAGE && living instanceof Player && this.getAnger(player = (Player)living) > 5) {
            return (float)((double)baseValue * (1.0 + (double)(this.getAnger(player) - 5) * Math.cbrt(modifier.getLevel()) * (double)0.1f));
        }
        return baseValue;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (this.getAnger(player) <= 5) {
                    arrow.m_36735_((int)Math.ceil((float)arrow.m_150123_() * (1.0f + (float)(6 - this.getAnger(player)) * 0.2f)));
                }
            }
        }
        return false;
    }
}

